/**
 * @file Drv_Timers.c
 * @author 吳星萍(iris@e-besthealth.com)
 * @brief  
 * @version 1.0
 * @date 2020-06-09
 *
 * @copyright BEST HEALTH ELECTRONIC INC (c) 2019
 *
 * Compiler Ver. : V3.57
 * IDE3000  Ver. : V8.03
 * MCU/CFG  Ver. : BH67F5362/1.1
 */
#include "Project_Global.h"
#include "BH67F5362.h"
#include "Drv_Timers.h"
#include "Drv_GPIO.h"

volatile bit PTM0_FLAG;

/**
 * @brief PTMn設置為計時/計數模式
 *
 * @param PTMn  0~7
 * @param timeClock enum TimerClock_t
 * @param Count 10bit PTM <1024   (n=0,1,4,5,6或7)
 * @param Count 16bit PTM <65536  (n=2~3)
 * @note Tus = 1000000 / TimeClock * Count
 * @warning 默認開啟中斷
 */
void Drv_PTMn_Timer_Init(unsigned char PTMn, enum TimerClock_t timeClock, unsigned int Count)
{
    if (PTMn == 0)
    {
        SET_PTMn_COUNT(0, Count);
        SET_PTMn_CLOCK(0, timeClock);
        SET_PTMn_MODE_TIMER(0);
        SET_PTMnA_ISR_ENABLE(0);
        SET_M_FUNCT_N_ENABLE(0);
    }
    else if (PTMn == 1)
    {
        SET_PTMn_COUNT(1,Count);
        SET_PTMn_CLOCK(1, timeClock);
        SET_PTMn_MODE_TIMER(1);
        SET_PTMnA_ISR_ENABLE(1);
        SET_M_FUNCT_N_ENABLE(1);
    }
    else if (PTMn == 2)
    {
        SET_PTMn_COUNT(2,Count);
        SET_PTMn_CLOCK(2, timeClock);
        SET_PTMn_MODE_TIMER(2);
        SET_PTMnA_ISR_ENABLE(2);
        SET_M_FUNCT_N_ENABLE(2);
    }
    else if (PTMn == 3)
    {
        SET_PTMn_COUNT(3,Count);
        SET_PTMn_CLOCK(3, timeClock);
        SET_PTMn_MODE_TIMER(3);
        SET_PTMnA_ISR_ENABLE(3);
        SET_M_FUNCT_N_ENABLE(4);
    }
    else if (PTMn == 4)
    {
        SET_PTMn_COUNT(4,Count);
        SET_PTMn_CLOCK(4, timeClock);
        SET_PTMn_MODE_TIMER(4);
        SET_PTMnA_ISR_ENABLE(4);
        SET_M_FUNCT_N_ENABLE(6);
    }

    else if (PTMn == 5)
    {
        SET_PTMn_COUNT(5,Count);
        SET_PTMn_CLOCK(5, timeClock);
        SET_PTMn_MODE_TIMER(5);
        SET_PTMnA_ISR_ENABLE(5);
        SET_M_FUNCT_N_ENABLE(7);
    }
    
    else if (PTMn == 6)
    {
        SET_PTMn_COUNT(6,Count);
        SET_PTMn_CLOCK(6, timeClock);
        SET_PTMn_MODE_TIMER(6);
        SET_PTMnA_ISR_ENABLE(6);
        SET_M_FUNCT_N_ENABLE(8);
    }
 
    else if (PTMn == 7)
    {
        SET_PTMn_COUNT(7,Count);
        SET_PTMn_CLOCK(7, timeClock);
        SET_PTMn_MODE_TIMER(7);
        SET_PTMnA_ISR_ENABLE(7);
        SET_M_FUNCT_N_ENABLE(9);
    }     
    _emi = 1;
}

/**
 * @brief PTMn設置為PWM模式
 *
 * @param PTMn  0~7
 * @param timeClock enum TimerClock_t
 * @param Count 10bit PTM <1024   (n=0,1,4,5,6或7)
 * @param Count 16bit PTM <65536  (n=2~3)
 * @note PWM Fre = timeClock / CCRP   Duty = CCRA / CCRP (if CCRA > CCRP duty=100)
 * @warning 默認開啟中斷
 */
void Drv_PTMn_PWM_Init(unsigned char PTMn, enum TimerClock_t timeClock, unsigned int Count)
{
    if (PTMn == 0)
    {
        SET_PTMn_COUNT(0, Count);
        SET_PTMn_CLOCK(0, timeClock);
        SET_PTMn_MODE_PWM(0);
        SET_PC2_PTP0();
        SET_PTMnA_ISR_ENABLE(0);
        SET_M_FUNCT_N_ENABLE(0);
    }
    else if (PTMn == 1)
    {
        SET_PTMn_COUNT(1,Count);
        SET_PTMn_CLOCK(1, timeClock);
        SET_PC4_PTP1();
        SET_PTMn_MODE_PWM(1);
        SET_PTMnA_ISR_ENABLE(1);
        SET_M_FUNCT_N_ENABLE(1);
    }
    else if (PTMn == 2)
    {
        SET_PTMn_COUNT(2,Count);
        SET_PTMn_CLOCK(2, timeClock);
        SET_PB3_PTP2();
        SET_PTMn_MODE_PWM(2);
        SET_PTMnA_ISR_ENABLE(2);
        SET_M_FUNCT_N_ENABLE(2);
    }
    else if (PTMn == 3)
    {
        SET_PTMn_COUNT(3,Count);
        SET_PTMn_CLOCK(3, timeClock);
        SET_PB2_PTP3();
        SET_PTMn_MODE_PWM(3);
        SET_PTMnA_ISR_ENABLE(3);
        SET_M_FUNCT_N_ENABLE(4);
    }
    else if (PTMn == 4)
    {
        SET_PTMn_COUNT(4,Count);
        SET_PTMn_CLOCK(4, timeClock);
        SET_PC3_PTP4();
        SET_PTMn_MODE_PWM(4);
        SET_PTMnA_ISR_ENABLE(4);
        SET_M_FUNCT_N_ENABLE(6);
    }
    else if (PTMn == 5)
    {
        SET_PTMn_COUNT(5,Count);
        SET_PTMn_CLOCK(5, timeClock);
        SET_PC5_PTP5();
        SET_PTMn_MODE_PWM(5);
        SET_PTMnA_ISR_ENABLE(5);
        SET_M_FUNCT_N_ENABLE(7);
    }
    else if (PTMn == 6)
    {
        SET_PTMn_COUNT(6,Count);
        SET_PTMn_CLOCK(6, timeClock);
        SET_PC7_PTP6();
        SET_PTMn_MODE_PWM(6);
        SET_PTMnA_ISR_ENABLE(6);
        SET_M_FUNCT_N_ENABLE(8);
    }
    else if (PTMn == 7)
    {
        SET_PTMn_COUNT(7,Count);
        SET_PTMn_CLOCK(7, timeClock);
        SET_PF2_PTP7();
        SET_PTMn_MODE_PWM(7);
        SET_PTMnA_ISR_ENABLE(7);
        SET_M_FUNCT_N_ENABLE(9);
    }
    
}

//@-------MuFunction0 中斷入口函數------------@
// PTM0 & STM0 共用
// 復合中斷需要自行清除Request Flags
DEFINE_ISR(MuFunction0_ISR, 0x014)
{
    if (_ptm0af)
    {
       	_pt0on=1;
        // User Code
        PTM0_FLAG=1;
    }
    else if (_ptm0pf)
    {
        _ptm0pf = 0;
        // User Code
    }

}
//@-------MuFunction1 中斷入口函數------------@
// PTM1 & STM1 共用
DEFINE_ISR(MuFunction1_ISR, 0x018)
{
    if (_ptm1af)
    {
        _ptm1af = 0;
        // User Code
    }
    else if (_ptm1pf)
    {
        _ptm1pf = 0;
        // User Code
    }
}

//@-------MuFunction2 中斷入口函數-------------@
// PTM2 
DEFINE_ISR(MuFunction2_ISR, 0x020)
{
    if (_ptm2af)
    {
        _ptm2af = 0;
        // User Code
    }
    else if (_ptm2pf)
    {
        _ptm2pf = 0;
        // User Code
    }
}

//@-------MuFunction4 中斷入口函數-------------@
// PTM3 & STM1 共用
DEFINE_ISR(MuFunction4_ISR, 0x038)
{
    if (_ptm3af)
    {
        _ptm3af = 0;
        // User Code
    }
    else if (_ptm3pf)
    {
        _ptm3pf = 0;
        // User Code
    }
}

//@-------MuFunction6 中斷入口函數-------------@
// PTM4
DEFINE_ISR(MuFunction6_ISR, 0x00C)
{
    if (_ptm4af)
    {
        _ptm4af = 0;
        // User Code
    }
    else if (_ptm4pf)
    {
        _ptm4pf = 0;
        // User Code
    }
}
//@-------MuFunction7 中斷入口函數------------@
// PTM5
DEFINE_ISR(MuFunction7_ISR, 0x010)
{
    if (_ptm5af)
    {
        _ptm5af = 0;
        // User Code
    }
    else if (_ptm5pf)
    {
        _ptm5pf = 0;
        // User Code
    }
}

//@-------MuFunction8 中斷入口函數-------------@
// PTM6 &Timebase0 共用
DEFINE_ISR(MuFunction8_ISR, 0x024)
{
    if (_ptm6af)
    {
        _ptm6af = 0;
        // User Code
    }
    else if (_ptm6pf)
    {
        _ptm6pf = 0;
        // User Code
    }
}

//@-------MuFunction9 中斷入口函數-------------@
// PTM7 &Timebase1 共用
DEFINE_ISR(MuFunction9_ISR, 0x028)
{
    if (_ptm7af)
    {
        _ptm7af = 0;
        // User Code
    }
    else if (_ptm7pf)
    {
        _ptm7pf = 0;
        // User Code
    }
}